/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken.api;

import com.floragunn.searchguard.authc.AuthInfoService;
import com.floragunn.searchguard.authtoken.AuthTokenService;
import com.floragunn.searchguard.authtoken.TokenCreationException;
import com.floragunn.searchguard.authtoken.api.CreateAuthTokenRequest;
import com.floragunn.searchguard.authtoken.api.CreateAuthTokenResponse;
import com.floragunn.searchguard.user.User;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportCreateAuthTokenAction
extends HandledTransportAction<CreateAuthTokenRequest, CreateAuthTokenResponse> {
    private final AuthTokenService authTokenService;
    private final AuthInfoService authInfoService;
    private final ThreadPool threadPool;

    @Inject
    public TransportCreateAuthTokenAction(TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, AuthTokenService authTokenService, AuthInfoService authInfoService) {
        super("cluster:admin:searchguard:authtoken/_own/create", transportService, actionFilters, CreateAuthTokenRequest::new);
        this.authTokenService = authTokenService;
        this.threadPool = threadPool;
        this.authInfoService = authInfoService;
    }

    protected final void doExecute(Task task, CreateAuthTokenRequest request, ActionListener<CreateAuthTokenResponse> listener) {
        User user = this.authInfoService.getCurrentUser();
        this.threadPool.generic().submit(() -> {
            try {
                listener.onResponse((Object)this.authTokenService.createJwt(user, request));
            }
            catch (TokenCreationException e) {
                listener.onFailure((Exception)new ElasticsearchStatusException(e.getMessage(), e.getRestStatus(), (Throwable)e, new Object[0]));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        });
    }
}

